<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Blogcat extends CI_Controller {

	public function __construct(){
		parent::__construct();
		$this->authmod->is_admin_login();
    }
	 
	
	
	public function index($page='', $msg=''){
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		//$data['id'] = $id;
		//$this->mylib->put_msg('Show Message');
		$data['list'] = $this->blog->cat_listing();
		$data['list_addedit'] = ADMIN_BASE_URL.$this->uri->segment(1).'/addedit_category/';
		$data['list_del'] = ADMIN_BASE_URL.$this->uri->segment(1).'/del_category/';
		
		$data['heading_text'] = 'Blog Management - Blog &gt;&gt; Category ';
		$data['body'] = $this->load->view('blogcat/category', $data, true);
		$this->load->view('layout', $data);
		
	}
	
	public function addedit_category($id=0, $msg=''){
		
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		$data['id'] = $id;
		$data['heading_text'] = 'Blog Management - Category ';
		$data['heading_text'].= ($data['id']=='' && $data['id']=='0')?'Create New':'Edit';
		$data['list_addedit'] = ADMIN_BASE_URL.$this->uri->segment(1).'/addedit_category/';
		$data['list_del'] = ADMIN_BASE_URL.$this->uri->segment(1).'/del_category/';
		$data['back'] = ADMIN_BASE_URL.$this->uri->segment(1).'/';
		$value = $this->input->post();
		
		$data['row'] = $this->blog->get_category_byid($id);
		
		if(isset($value['name'])){
			$this->form_validation->set_rules('name', 'Name of Category ', 'required');
			if($id == 0){ 
				$this->form_validation->set_rules('urlkey', 'Category URLKEY ', 'required|is_unique[p_blog_category.urlkey]');
			}else{
				if($value['urlkey_new']!='') {
					$this->form_validation->set_rules('urlkey_new', 'Category URLKEY ', 'is_unique[p_blog_category.urlkey]');
					$value['urlkey'] = $value['urlkey_new'];
				}
			}
			if ($this->form_validation->run()){
				if($value['id']==''){ unset($value['id']); }
				$id = $this->ds->save('p_blog_category' , $value);
				$this->mylib->put_msg('Category saved', 1);
				redirect('blogcat/');
				exit();
			}else{
				$this->mylib->put_msg(validation_errors(), 0);
				//if($id > 0) 
				$data['row'] = $value;
			}
		}
		
		
		$data['body'] = $this->load->view('blogcat/category_addedit', $data, true);
		$this->load->view('layout', $data);
		
		
	}
	
	public function del_tag($id=0){
		if($id){
			$this->blog->del_tag($id);
			redirect('catalog/tags/');
		}else{
			redirect('catalog/tags/');
			exit();
		}
	}
	
	public function tags($page='', $msg=''){
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		//$data['id'] = $id;
		//$this->mylib->put_msg('Show Message');
		$data['list'] = $this->blog->tag_listing();
		$data['list_addedit'] = ADMIN_BASE_URL.$this->uri->segment(1).'/addedit_tag/';
		$data['list_del'] = ADMIN_BASE_URL.$this->uri->segment(1).'/del_tag/';
		
		
		$data['heading_text'] = 'Blog Management -  Tags ';
		$data['body'] = $this->load->view('blogcat/category', $data, true);
		$this->load->view('layout', $data);
		
	}
	
	public function addedit_tag($id=0, $msg=''){
		
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		$data['id'] = $id;
		$data['heading_text'] = 'Blog Management - Tags ';
		$data['heading_text'].= ($data['id']=='' && $data['id']=='0')?'Create New':'Edit';
		$data['list_addedit'] = ADMIN_BASE_URL.$this->uri->segment(1).'/addedit_tag/';
		$data['list_del'] = ADMIN_BASE_URL.$this->uri->segment(1).'/del_category/';
		$data['back'] = ADMIN_BASE_URL.$this->uri->segment(1).'/tags';
		$value = $this->input->post();
		
		$data['row'] = $this->blog->get_tag_byid($id);
		
		if(isset($value['name'])){
			$this->form_validation->set_rules('name', 'Name of tag ', 'required');
			if($id == 0) $this->form_validation->set_rules('urlkey', 'Tag URLKEY ', 'required|is_unique[p_blog_tags.urlkey]');
			else{
				if($value['urlkey_new']!='') {
					$this->form_validation->set_rules('urlkey_new', 'Tag URLKEY ', 'is_unique[p_blog_tags.urlkey]');
					$value['urlkey'] = $value['urlkey_new'];
				}
			}
			if ($this->form_validation->run()){
				if($value['id']==''){ unset($value['id']); }
				$id = $this->ds->save('p_blog_tags' , $value);
				$this->mylib->put_msg('Tag saved', 1);
				redirect('blogcat/tags');
				exit();
			}else{
				$this->mylib->put_msg(validation_errors(), 0);
				//if($id > 0) 
				$data['row'] = $value;
			}
		}
		
		
		$data['body'] = $this->load->view('blogcat/category_addedit', $data, true);
		$this->load->view('layout', $data);
		
		
	}
	
	public function archieves($page='', $msg=''){
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		//$data['id'] = $id;
		//$this->mylib->put_msg('Show Message');
		$data['list'] = $this->blog->archieves_listing();
		$data['list_addedit'] = ADMIN_BASE_URL.$this->uri->segment(1).'/addedit_archieves/';
		$data['list_del'] = ADMIN_BASE_URL.$this->uri->segment(1).'/del_archieves/';
		
		
		$data['heading_text'] = 'Blog Management -  Archieves ';
		$data['body'] = $this->load->view('blogcat/category', $data, true);
		$this->load->view('layout', $data);
		
	}
	
	public function addedit_archieves($id=0, $msg=''){
		
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		$data['id'] = $id;
		$data['heading_text'] = 'Blog Management - Archieves ';
		$data['heading_text'].= ($data['id']=='' && $data['id']=='0')?'Create New':'Edit';
		$data['list_addedit'] = ADMIN_BASE_URL.$this->uri->segment(1).'/addedit_archieves/';
		$data['back'] = ADMIN_BASE_URL.$this->uri->segment(1).'/archieves';
		$value = $this->input->post();
		
		$data['row'] = $this->blog->get_archieves_byid($id);
		
		if(isset($value['name'])){
			$this->form_validation->set_rules('name', 'Name of archieves ', 'required');
			if($id == 0) $this->form_validation->set_rules('urlkey', 'archieves URLKEY ', 'required|is_unique[p_blog_archieves.urlkey]');
			else{
				if($value['urlkey_new']!='') {
					$this->form_validation->set_rules('urlkey_new', 'archieves URLKEY ', 'is_unique[p_blog_archieves.urlkey]');
					$value['urlkey'] = $value['urlkey_new'];
				}
			}
			
			if ($this->form_validation->run()){
				if($value['id']==''){ unset($value['id']); }
				$id = $this->ds->save('p_blog_archieves' , $value);
				$this->mylib->put_msg('Tag saved', 1);
				redirect('blogcat/archieves');
				exit();
			}else{
				$this->mylib->put_msg(validation_errors(), 0);
				//if($id > 0) 
				$data['row'] = $value;
			}
		}
		
		
		$data['body'] = $this->load->view('blogcat/category_addedit', $data, true);
		$this->load->view('layout', $data);
		
		
	}
	
	
	
}