<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Blogs extends CI_Controller {

	public function __construct(){
		parent::__construct();
		$this->authmod->is_admin_login();
    }
	 
	
	
	public function index($page='', $msg=''){
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		$data['listing'] = $this->blog->listing();
		$data['list_addedit'] = ADMIN_BASE_URL.$this->uri->segment(1).'/addedit/';
		$data['list_del'] = ADMIN_BASE_URL.$this->uri->segment(1).'/del/';
		
		$data['heading_text'] = 'Blog Management - Blog ';
		$data['body'] = $this->load->view('blog/listing', $data, true);
		$this->load->view('layout', $data);
		
	}
	
	public function addedit($id=0, $stp=''){
		
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		$data['id'] = $id;
		$data['heading_text'] = 'Blog Management - Blog ';
		$data['heading'] = ($data['id']=='' && $data['id']=='0')?'Create New':'Edit';
		$data['list_addedit'] = ADMIN_BASE_URL.$this->uri->segment(1).'/addedit/';
		$data['list_del'] = ADMIN_BASE_URL.$this->uri->segment(1).'/del_img/';
		$data['back'] = ADMIN_BASE_URL.$this->uri->segment(1).'/';
		$data['editer']=array('article');
		$value = $this->input->post();
		
		$data['row'] = $this->blog->get_blog($id, 'id');
		
		if(isset($value['step']) ){
			if($value['step']==1){	
				if(isset($value['tg'])){
					$tag = implode('||', $value['tg']);
					if($tag!='') $tag = '|'.$tag.'|';
				}else{
					$tag = '';
				}
				$value['tag'] = $tag;
				
				
				
				$this->form_validation->set_rules('title', 'Blog Title ', 'required');
				
				if($id == 0){ 
					$this->form_validation->set_rules('urlkey', 'Blog URLKEY ', 'required|is_unique[p_blog.urlkey]');
				}else{
					if($value['urlkey_new']!='') {
						$this->form_validation->set_rules('urlkey_new', 'Blog URLKEY ', 'is_unique[p_blog.urlkey]');
						$value['urlkey'] = $value['urlkey_new'];
					}
				}
				
				if ($this->form_validation->run()){
					if($value['id']==''){ unset($value['id']); }
					$id = $this->ds->save('p_blog' , $value);
					$this->mylib->put_msg('Category saved', 1);
					redirect('blogs/addedit/'.$id.'/step2');
					exit();
				}else{
					$this->mylib->put_msg(validation_errors(), 0);
					//if($id > 0) 
					$data['row'] = $value;
				}
			}
			if($value['step']==2){		
				$img = $this->media->upload('blog_image', 'blog', $value['id']);
				if($value['blog']==1){
					$arr['id'] = $value['id'];
					$arr['img'] = $img;
					$d = $this->ds->save('p_blog' , $arr);
					
				}
				//redirect('blogs/upload_img/'.$id, 'refresh');
				redirect("blogs/addedit/$id/step2", 'refresh');
					exit();
			}
			if($value['step']==3){	
				$value['article'] = addslashes($value['article']);
				$d = $this->ds->save('p_blog' , $value);
				$this->mylib->put_msg('Article saved', 1);
				redirect('blogs/addedit/'.$id.'/');
				exit();
			}
		}
		
		
		$data['body'] = $this->load->view('blog/addedit', $data, true);
		$this->load->view('layout', $data);
		
		
	}
	
	public function del_img($id=0){
		
			$this->media->delete($id, $arr);
			
			$id = $arr['tab_id'];
			redirect("blogs/addedit/$id/step2", 'refresh');
		
	}
	
	public function upload_img($id, $st='2'){
		$value = $this->input->post();
		
			
			redirect("blogs/addedit/$id/step2", 'refresh');
		
	}
	
	
}