<?php
class Members extends CI_Controller {

	public function __construct(){
		parent::__construct();
		$this->authmod->is_admin_login();
    }
	
	public function index(){
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		$data['heading_text'] = ' Member List';

		$data['add_new'] = ADMIN_BASE_URL."members/edit/";
		$data['listing'] = $this->user->listing();
		$data['get'] = $this->user->search();
		
		$data['body'] = $this->load->view('member/index', $data, true);
		$this->load->view('layout', $data);

	}
	
	public function edit($id){
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		$data['heading_text'] = ' Member Review';
		$data['id'] = $id;
		$row = $this->user->get($id);
		
		if(isset($_POST['submit'])){ 
			$value = $this->input->post();
			$value['id'] = $id;
			$id = $this->ds->save('p_users' , $value);
			$msg = $this->load->view('email/membership', array('id'=>$id), true);
			$sub = "Mendocino Access Television - Member Record modified ";
			$this->sendmail->send($row['email'], $sub, $msg);
			
			$this->mylib->put_msg('Member record plan and validity modified <br> Also a notification send to member.', 1);
			redirect('members/edit/'.$id);
			exit();
		}
		
		$data['listing'] = $this->user->pay_list_by_user($id);
		
		$data['body'] = $this->load->view('member/edit', $data, true);
		$this->load->view('layout', $data);

	}

	public function plan(){
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		$data['heading_text'] = ' List';

		$data['add_new'] = ADMIN_BASE_URL."members/addedit_plan/";
		$data['listing'] = $this->user->plans('admin');
		$data['body'] = $this->load->view('member/plan', $data, true);
		$this->load->view('layout', $data);

	}

	public function addedit_plan($id=''){
		$layout_data = array();
		$data = array();
		$data['heading_text'] = (($id==0 || $id=='')?'Add New':'Edit').' Plan ';
		$data['row'] = $this->user->planinfo($id);
		$data['id'] = $id;
		
		if(isset($_POST['submit'])){ 
			$this->form_validation->set_rules('title', ' Plan title', 'required');
			$this->form_validation->set_rules('cost', ' Plan', 'required');
			$value = $this->input->post();
			
			if ($this->form_validation->run()){
				
				$id = $this->ds->save('p_plan' , $value);

				
				$this->mylib->put_msg('Plan saved', 1);
				redirect('members/plan/');
				exit();

			}else{

				$data['row'] = $this->input->post();
				$this->mylib->put_msg(validation_errors(), 0);

			}

		}

		$data['body'] = $this->load->view('member/addedit_plan', $data, true);
		$this->load->view('layout', $data);
	}
	
	
	public function exchangerequest(){
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		$data['heading_text'] = ' List';
		
		if(isset($_POST['admin_send'])){ 
			$val = $this->input->post();
			$arr['id'] = $val['admin_send'];
			$arr['amt'] = $val['amt'];
			$arr['status'] = 1;
			$id = $this->ds->save('p_exchange' , $arr);
			$this->exchange->request_email($arr['id']);
			
			$this->mylib->put_msg('Request send to member', 1);
			redirect('members/exchangerequest/');
			exit();
		}
		
		$data['listing'] = $this->exchange->listing();
		$data['body'] = $this->load->view('member/exchangerequest', $data, true);
		$this->load->view('layout', $data);

	}
	

}

