<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pages extends CI_Controller {

	public function __construct()
    {
		parent::__construct();
		$this->authmod->is_admin_login();
    }

	public function index()
	{
		$layout_data = array();
		$data = array();

		//if($msg=='smsgd'){ $this->mylib->put_msg('One CMS Remove Successfully'); }

		//$data['heading_text'] = 'Manage Pages';

		$data['cmslist'] = $this->cms->cmslist();
		$data['cmslist_addedit'] = ADMIN_BASE_URL."pages/addedit/";
		$data['cmslist_del'] = ADMIN_BASE_URL."pages/delete/";

		$data['body'] = $this->load->view('cms/index', $data, true);

		$this->load->view('layout', $data);

	}


	public function addedit($id=0){

		$layout_data = array();

		$data = array();

		$data['id'] = $id;

		//$data['heading_text'] = 'Manage Pages';

		if($id > 0){

			$data['row'] = $this->cms->get_cms_byid($id);

		}else{

		}

		$data['body'] = $this->load->view('cms/cms_addedit', $data, true);

		$this->load->view('layout', $data);

	}

	

	public function editcontent($id=0){

		$layout_data = array();

		$data = array();

		$data['id'] = $id;

		//$data['heading_text'] = 'Manage Pages';

		$data['row'] = $this->cms->get_cms_byid($id);

		

		$data['editer']=array('content');

		$data['body'] = $this->load->view('cms/cms_addedit', $data, true);

		$this->load->view('layout', $data);

	}

	

	public function editarticle($id=0, $article_id=0){

		$layout_data = array();

		$data = array();

		$data['id'] = $id;

		//$data['heading_text'] = 'Manage Pages';

		$data['row'] = $this->cms->get_cms_byid($id);

		$data['ar'] = $this->cms->get_article_byid($article_id);

		$data['editer']=array('content');

		$data['body'] = $this->load->view('cms/cms_addedit', $data, true);

		$this->load->view('layout', $data);

	}



	public function addedit2($id=0, $msg=''){

		$layout_data = array();

		$data = array();

		$this->authmod->is_admin_login();

		$data['user_name'] = $this->session->userdata('user_name');

		if($msg=='seccupd'){ $msg="Successfully Update"; }

		$data['msg'] = $msg;

		$data['id'] = $id;



		if($id > 0){

			$data['row'] = $this->cms->get_cms_byid($id);

		}else{



		}

		//$data['title_heading'] = 'Pages';

		$data['data_info'] = $this->load->view('cms_addedit2', $data, true);

		$data['body'] = $this->load->view('common/body', $data, true);

		$this->load->view('layout', $data);

	}



	

	

	public function addedit2_act(){

		if(!$_POST){

			redirect('pages/');

			exit();

		}

		

		$value = $this->input->post();



		if(isset($value['id'])){

			$this->cms->update_act3($value);

			redirect('pages/addedit/'.$value['id'].'/seccupd');

			exit();

		}

		

		redirect('pages/');

		exit();

	}

	



	public function addedit_act(){

		if(!$_POST){

			redirect('pages/');

			exit();

		}

		

		$value = $this->input->post();



		if(isset($value['id'])){

			$this->cms->update_act1($value);

			$this->mylib->put_msg('Data Saved . . . . ', 1);

			redirect('pages/addedit/'.$value['id'].'/');

			exit();

		}else{

			$this->form_validation->set_rules('urlkey', 'Page URL Key', 'required');

			$this->form_validation->set_rules('urlkey', 'Page URL Key must be unick', 'required|is_unique[p_cms.urlkey]');

			if ($this->form_validation->run()){

				$id = $this->cms->insert_act($value);

				redirect('pages/addedit/'.$id.'/');

				exit();

			}else{

				$this->addedit();

				exit();

			}

		}

		redirect('pages/');

		exit();

	}



	public function editcontent_act(){

		$value = $this->input->post();

		$id = $value['id'];

		if($id){

			$this->cms->update_act2($value);

			$this->mylib->put_msg('Page Content Updated Successfully . . . . ', 1);

			redirect('pages/addedit/'.$id.'');

		}else{

			redirect('pages/');

			exit();

		}

	}



	public function editarticle_act(){

		$value = $this->input->post();

		$id = $value['id'];

		$cms = $value['cms_id'];

		if($id){

			$this->cms->update_act3($value);

			$this->mylib->put_msg("Article No. $id Updated Successfully . . . . ", 1);

			redirect('pages/addedit/'.$cms.'');

		}else{

			redirect('pages/');

			exit();

		}

	}



	public function files(){

		$layout_data = array();

		$data = array();

		$this->authmod->is_admin_login();

		$data['user_name'] = $this->session->userdata('user_name');

		$dir = FCKEDITOR_HEARDPATH."userfiles/image/";

		$sub_fol = '';

		if(isset($_GET['fol']) && $_GET['fol']!=''){

			$dir = $dir.$_GET['fol'].'';

			$sub_fol = $_GET['fol'].'';

		}



		if(isset($_GET['act']) && $_GET['act']=='del'){	

			$name = $_GET['name'];

			$type = $_GET['type'];

			$m='';

			if($type=='dir'){

				rmdir($dir  .'/'. $name);

			}

			if($type=='file'){

				@unlink($dir  .'/'. $name);

			}		

			if($sub_fol!=''){ $sub_fol='?fol='.$sub_fol; }

			redirect('pages/files/'.$sub_fol);

			exit();

		}



		$files = array();

		//$dir = FCKEDITOR_BASEPATH."image/";

		if (is_dir($dir)) {

			if ($dh = opendir($dir)) {

				while (($file = readdir($dh)) !== false) {

					if($file!='.' && $file!='..'){

						$arr['type'] = filetype($dir .'/'. $file);

						$arr['name'] = $file;

						$arr['num_flies'] = $this->cms->num_flies($file, $sub_fol);

						$files[] = $arr;

					}

				}

				closedir($dh);

			}

		}



		$data['files'] = $files;

		$data['dir'] = $dir;

		$data['sub_fol'] = $sub_fol;

		$data['data_info'] = $this->load->view('files', $data, true);

		$data['title_heading'] = 'Manage Uploaded File From Editor ';

		$data['body'] = $this->load->view('common/body', $data, true);

		$this->load->view('layout', $data);

	}



	



	public function delete($id=0){

		if($id){

			$this->cms->delete($id);

			redirect('pages/index/smsgd/');

		}else{

			redirect('pages/');

			exit();

		}

	}



	

	public function menu(){

		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();

		//$data['heading_text'] = ' Manage Menu';

		$data['add_new'] = ADMIN_BASE_URL."pages/addeditmenu/";
		$data['del'] = ADMIN_BASE_URL."pages/del_menu/";
		$data['listing'] = $this->menu->listing();
		$data['body'] = $this->load->view('menu/index', $data, true);

		$this->load->view('layout', $data);

	}

	

	public function addeditmenu($id=''){

		$layout_data = array();
		$data = array();

		$data['heading_text'] = (($id==0 || $id=='')?'Add New':'Edit').' Menu ';
		$data['row'] = $this->menu->get($id);

		if(isset($_POST['submit'])){ 

			$this->form_validation->set_rules('title', ' Menu Name ', 'required');

			if ($this->form_validation->run()){
				$value = $this->input->post();
				$id = $this->ds->save('p_menu' , $value);
				$this->mylib->put_msg('Record saved....', 1);
				redirect('pages/menu/');
				exit();
			}else{

				$data['row'] = $this->menu->get($id);
				$this->mylib->put_msg(validation_errors(), 0);

			}
		}

		$data['body'] = $this->load->view('menu/addedit', $data, true);
		$this->load->view('layout', $data);

	}

	
	public function del_menu($id=0){
		if($id){
			$this->db->delete('p_menu', array('id' => $id)); 
			redirect('pages/menu/');
		}else{
			redirect('pages/');
			exit();
		}

	}
	

	

}