<?php
class Report extends CI_Controller {


	public function __construct(){
		parent::__construct();
		$this->authmod->is_admin_login();
    }
	
	public function landlord(){
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		$data['heading_text'] = 'Landlord List';
		
		$data['listing'] = $listing = $this->landlord->report();
		$data['get'] = $this->landlord->report_search();
		
		$data['excel'] = ADMIN_BASE_URL."report/landlord/?excel";
		
		if(isset($_GET['excel'])){
			
			header("Pragma: public");
			header("Expires: 0");
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
			header("Content-Type: application/force-download");
			header("Content-Type: application/octet-stream");
			header("Content-Type: application/download");;
			header("Content-Disposition: attachment;filename=landlord.csv "); 
			header("Content-Transfer-Encoding: binary ");
			
			$this->cms->xlsBOF();
			$this->cms->xlsWriteLabel(0,0,"LANDLOARD ID");
			$this->cms->xlsWriteLabel(0,1,"NAME");
			$this->cms->xlsWriteLabel(0,2,"CONTACTS");
			$this->cms->xlsWriteLabel(0,3,"EMAIL");
			$this->cms->xlsWriteLabel(0,4,"REG. DATE");
			$this->cms->xlsWriteLabel(0,5,"KYC STATUS");
			$this->cms->xlsWriteLabel(0,6,"TOTAL AD");
			$this->cms->xlsWriteLabel(0,7,"ACTIVE AD");
			
			$xlsRow = 2;
			
			foreach($listing as $row){
				$kyc = ($row['kyc_status']==1)?'OK':'NO';
				$n1 = $this->landlord->all_ad($row['id']);
				$n2 = $this->landlord->active_ad($row['id']);
				
				$this->cms->xlsWriteNumber($xlsRow, 0, $row['id']);
				$this->cms->xlsWriteLabel($xlsRow, 1, $row['name']);
				$this->cms->xlsWriteLabel($xlsRow, 2, $row['mobile'] );
				$this->cms->xlsWriteLabel($xlsRow, 3,  $row['email']);
				$this->cms->xlsWriteLabel($xlsRow, 4,  $row['reg_date']);
				$this->cms->xlsWriteLabel($xlsRow, 5,  $kyc );
				$this->cms->xlsWriteNumber($xlsRow, 6, $n1 );
				$this->cms->xlsWriteNumber($xlsRow, 7, $n1 );
					
				$xlsRow++;
			}
			
			$this->cms->xlsEOF();
			exit();
		}
		
		
		$data['body'] = $this->load->view('member/report', $data, true);
		$this->load->view('layout', $data);
		
	}
	
	public function ad(){
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		$data['heading_text'] = 'AD Report';
		
		$data['listing'] = $listing = $this->adv->adreport();
		$data['get'] = $this->adv->adreport_search();
		
		
		$data['excel'] = ADMIN_BASE_URL."report/ad/?excel";
		
		if(isset($_GET['excel'])){
			
			header("Pragma: public");
			header("Expires: 0");
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
			header("Content-Type: application/force-download");
			header("Content-Type: application/octet-stream");
			header("Content-Type: application/download");;
			header("Content-Disposition: attachment;filename=ad.csv "); 
			header("Content-Transfer-Encoding: binary ");


			
			$this->cms->xlsBOF();
			$this->cms->xlsWriteLabel(0,0,"AD ID");
			$this->cms->xlsWriteLabel(0,1,"PROPERTY TITLE");
			$this->cms->xlsWriteLabel(0,2,"LANDLOARD NAME");
			$this->cms->xlsWriteLabel(0,3,"AD STATUS");
			$this->cms->xlsWriteLabel(0,4,"PAY STATUS");
			$this->cms->xlsWriteLabel(0,5,"START DATE");
			$this->cms->xlsWriteLabel(0,6,"END DATE");
			
			$xlsRow = 2;
		
			foreach($listing as $ro){
				$status = ($ro['status']==1)?'Active':'Inactive';
				$title = $ro['title']. ' (' . $ro['loc'] . ')';
				$n1 = ($ro['paid']==1)?'Paid':'Not Paid';
				$n2 = ($ro['paid']==1)? indian_date($ro['active_on']) :'';
				$n3 = ($ro['paid']==1)? indian_date($ro['expire_on']) :'';
				
				$this->cms->xlsWriteNumber($xlsRow, 0, $ro['id']);
				$this->cms->xlsWriteLabel($xlsRow, 1, $title);
				$this->cms->xlsWriteLabel($xlsRow, 2, $ro['landlord_name'] );
				$this->cms->xlsWriteLabel($xlsRow, 3,  $status);
				$this->cms->xlsWriteLabel($xlsRow, 4,  $n1 );
				$this->cms->xlsWriteLabel($xlsRow, 5,  $n2 );
				$this->cms->xlsWriteLabel($xlsRow, 6, $n3 );
					
				$xlsRow++;
			}
			
			$this->cms->xlsEOF();
			exit();
		}
		
		$data['body'] = $this->load->view('listing/adreport', $data, true);
		$this->load->view('layout', $data);
		
	}
	
	public function revenue(){
		$layout_data = array();
		$data = array();
		$this->authmod->is_admin_login();
		$data['heading_text'] = 'Revenue Report';
		
		$data['listing'] = $listing =  $this->adv->ad_revenue();
		$data['get'] = $this->adv->ad_revenue_search();
		
		$data['excel'] = ADMIN_BASE_URL."report/revenue/?excel";
		
		if(isset($_GET['excel'])){
			
			header("Pragma: public");
			header("Expires: 0");
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
			header("Content-Type: application/force-download");
			header("Content-Type: application/octet-stream");
			header("Content-Type: application/download");;
			header("Content-Disposition: attachment;filename=revenue.csv "); 
			header("Content-Transfer-Encoding: binary ");


			
			$this->cms->xlsBOF();
			$this->cms->xlsWriteLabel(0,0,"AD ID");
			$this->cms->xlsWriteLabel(0,1,"TNX ID");
			$this->cms->xlsWriteLabel(0,2,"AD ID");
			$this->cms->xlsWriteLabel(0,3,"PROPERTY TITLE");
			$this->cms->xlsWriteLabel(0,4,"LANDLOARD NAME");
			$this->cms->xlsWriteLabel(0,5,"AMOUNT(INR)");
			$this->cms->xlsWriteLabel(0,6,"PAY DATE");
			$this->cms->xlsWriteLabel(0,7,"START DATE");
			$this->cms->xlsWriteLabel(0,8,"END DATE");
			
			$xlsRow = 2;


		
			foreach($listing as $ro){
				$n1 = indian_date($ro['paid_date']);
				$n2 = indian_date($ro['active_on']);
				$n3 = indian_date($ro['expire_on']);
				
				$this->cms->xlsWriteNumber($xlsRow, 0, $ro['id']);
				$this->cms->xlsWriteLabel($xlsRow, 1, $ro['tnx_id']);
				$this->cms->xlsWriteNumber($xlsRow, 2, $ro['listing_id'] );
				$this->cms->xlsWriteLabel($xlsRow, 3,  $ro['ad_title']);
				$this->cms->xlsWriteLabel($xlsRow, 4,  $ro['landlord_name'] );
				$this->cms->xlsWriteLabel($xlsRow, 5,  $ro['fees'] );
				$this->cms->xlsWriteLabel($xlsRow, 6, $n1 );
				$this->cms->xlsWriteLabel($xlsRow, 7, $n2 );
				$this->cms->xlsWriteLabel($xlsRow, 8, $n3 );
					
				$xlsRow++;
			}
			
			$this->cms->xlsEOF();
			exit();
		}
		
		
		$data['body'] = $this->load->view('listing/revenue_report', $data, true);
		$this->load->view('layout', $data);
		
	}
	
	
}
