<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

 

class Thumb {

   

   public $image;

   public $image_type;

   public $height;

   public $width;

	

	

	public function img_resize($filename, $path='', $h, $w, $thumb_file_path='tmp', $file='', $remove=0){

		$source_file = FILE_PATH.$path.'/'.$filename;

		$this->load($source_file);

		$this->resize($w, $h);

		if($path==$thumb_file_path){ $thumb_file_path = 'tmp'; }

		if($file=='') { $file = $filename; }

		$dest_file = FILE_PATH.$thumb_file_path.'/'.$file;

		$this->save($dest_file);

		if($thumb_file_path == 'tmp'){

			@unlink($source_file);

			$r = copy($dest_file, $source_file);

			@unlink($dest_file);

		}else{

			if($remove==1){

				@unlink($source_file);

			}

		}

	}

	

	public function img_resize_by($filename, $path='', $p, $n, $file='', $thumb_file_path='tmp', $remove=0){

		$source_file = FILE_PATH.$path.'/'.$filename;

		$this->load($source_file);

		$this->resizeby($p, $n);

		if($path==$thumb_file_path){ $thumb_file_path = 'tmp'; }

		if($file=='') { $file = $filename; }

		$dest_file = FILE_PATH.$thumb_file_path.'/'.$file;

		$this->save($dest_file);

		if($thumb_file_path == 'tmp'){

			@unlink($source_file);

			$r = copy($dest_file, $source_file);

			@unlink($dest_file);

		}else{

			if($remove==1){

				@unlink($source_file);

			}

		}

	}

	

   public function load($filename) {

   	  //$filename = FILE_PATH.$path.$filename;

   	  list ($width_orig, $height_orig)=@getimagesize($filename);

	  $this->height=$height_orig;

	  $this->width=$width_orig;

      $image_info = getimagesize($filename);

      $this->image_type = $image_info[2];

      if( $this->image_type == IMAGETYPE_JPEG ) {

         $this->image = imagecreatefromjpeg($filename);

      } elseif( $this->image_type == IMAGETYPE_GIF ) {

         $this->image = imagecreatefromgif($filename);

      } elseif( $this->image_type == IMAGETYPE_PNG ) {

         $this->image = imagecreatefrompng($filename);

      }

   }

   public function save($filename, $image_type=IMAGETYPE_JPEG, $compression=75, $permissions=null) {

      if( $image_type == IMAGETYPE_JPEG ) {

         @imagejpeg($this->image,$filename,$compression);

      } elseif( $image_type == IMAGETYPE_GIF ) {

         @imagegif($this->image,$filename);         

      } elseif( $image_type == IMAGETYPE_PNG ) {

         @imagepng($this->image,$filename);

      }   

      if( $permissions != null) {

         chmod($filename,$permissions);

      }

   }

   public function output($image_type=IMAGETYPE_JPEG) {

      if( $image_type == IMAGETYPE_JPEG ) {

         imagejpeg($this->image);

      } elseif( $image_type == IMAGETYPE_GIF ) {

         imagegif($this->image);         

      } elseif( $image_type == IMAGETYPE_PNG ) {

         imagepng($this->image);

      }   

   }

   public function getWidth() {

      return imagesx($this->image);

   }

   public function getHeight() {

      return imagesy($this->image);

   }

   public function resizeToHeight($height) {

      $ratio = $height / $this->getHeight();

      $width = $this->getWidth() * $ratio;

      $this->resize($width,$height);

   }

   public function resizeToWidth($width) {

      $ratio = $width / $this->getWidth();

      $height = $this->getheight() * $ratio;

      $this->resize($width,$height);

   }

   public function scale($scale) {

      $width = $this->getWidth() * $scale/100;

      $height = $this->getheight() * $scale/100; 

      $this->resize($width,$height);

   }

   public function resize($width,$height) {

      $new_image = imagecreatetruecolor($width, $height);

      imagecopyresampled($new_image, $this->image, 0, 0, 0, 0, $width, $height, $this->getWidth(), $this->getHeight());

      $this->image = $new_image;   

   }  

   public function resizeby($p,$n) {

   	  $width = $height = 0;

	  

	  $width_orig = $this->width;

	  $height_orig = $this->height;

	  

	  if($p=='w'){

			$width=$n;

			if ($width  < $width_orig){

					$height=($height_orig * $width) / $width_orig;

					$height=intval($height);

			}else{ $height=$height_orig; $width=$width_orig; }

		}

		if($p=='h'){

			$height=$n;

			if ($height < $height_orig){

					$width=($width_orig * $height) / $height_orig;

					$width=intval($width);

			}else{ $width=$width_orig; $width=$width_orig; }

		}

      $new_image = imagecreatetruecolor($width, $height);

      imagecopyresampled($new_image, $this->image, 0, 0, 0, 0, $width, $height, $this->getWidth(), $this->getHeight());

      $this->image = $new_image;   

   }  

        

}



/*------------------------------------------------------------*/



	/*include('SimpleImage.php');

   $image = new SimpleImage();

   $image->load('picture.jpg');

   $image->resize(250,400);

   $image->save('picture2.jpg');*/





/*------------------------------------------------------------*/



/*include('SimpleImage.php');

   $image = new SimpleImage();

   $image->load('picture.jpg');

   $image->resizeToWidth(250);

   $image->save('picture2.jpg');

*/



/*------------------------------------------------------------*/



/*include('SimpleImage.php');

   $image = new SimpleImage();

   $image->load('picture.jpg');

   $image->scale(50);

   $image->save('picture2.jpg');*/



/*------------------------------------------------------------*/



/*include('SimpleImage.php');

   $image = new SimpleImage();

   $image->load('picture.jpg');

   $image->resizeToHeight(500);

   $image->save('picture2.jpg');

   $image->resizeToHeight(200);

   $image->save('picture3.jpg');*/



/*------------------------------------------------------------*/



/* header('Content-Type: image/jpeg');

   include('SimpleImage.php');

   $image = new SimpleImage();

   $image->load('picture.jpg');

   $image->resizeToWidth(150);

   $image->output();*/



/*------------------------------------------------------------*/



   /*if( isset($_POST['submit']) ) {

      include('SimpleImage.php');

      $image = new SimpleImage();

      $image->load($_FILES['uploaded_image']['tmp_name']);

      $image->resizeToWidth(150);

      $image->output();

   } else {



   <form action="upload.php" method="post" enctype="multipart/form-data">

      <input type="file" name="uploaded_image" />

      <input type="submit" name="submit" value="Upload" />

   </form>

 */