<?php
class Blog extends CI_Model {

	var $atr;
	
	function __construct()
	{
		// Call the Model constructor
		parent::__construct();
		$this->atr = array();
	}
    
	function cat_listing(){
		
		$sql = "SELECT c . *  FROM `p_blog_category` c  WHERE c.status <> '2'";
		$query = $this->db->query($sql);
   		$config['per_page'] = 20;
		$config['uri_segment'] = 3;
		$config['total_rows'] = $query->num_rows();
		$config['base_url'] = ADMIN_BASE_URL.'blogcat/index/';
		$offset = $this->uri->segment($config['uri_segment']);
		if(!$offset){ $offset = 0; }
		$this->mypagination->initialize($config); 
		
		$sql = $sql . " LIMIT " . $offset . ", ".$config['per_page'];
		$query = $this->db->query($sql);
		
		return $query->result_array();
			
	}
	
	function tag_listing(){
		
		$sql = "SELECT c . *  FROM `p_blog_tags` c  WHERE c.status <> '2'";
		$query = $this->db->query($sql);
   		$config['per_page'] = 20;
		$config['uri_segment'] = 3;
		$config['total_rows'] = $query->num_rows();
		$config['base_url'] = ADMIN_BASE_URL.'blogcat/tag/';
		$offset = $this->uri->segment($config['uri_segment']);
		if(!$offset){ $offset = 0; }
		$this->mypagination->initialize($config); 
		
		$sql = $sql . " LIMIT " . $offset . ", ".$config['per_page'];
		$query = $this->db->query($sql);
		
		return $query->result_array();
			
	}
	
	function archieves_listing(){
		
		$sql = "SELECT c . *  FROM `p_blog_archieves` c  WHERE c.status <> '2'";
		$query = $this->db->query($sql);
   		$config['per_page'] = 20;
		$config['uri_segment'] = 3;
		$config['total_rows'] = $query->num_rows();
		$config['base_url'] = ADMIN_BASE_URL.'blogcat/archieves/';
		$offset = $this->uri->segment($config['uri_segment']);
		if(!$offset){ $offset = 0; }
		$this->mypagination->initialize($config); 
		
		$sql = $sql . " LIMIT " . $offset . ", ".$config['per_page'];
		$query = $this->db->query($sql);
		
		return $query->result_array();
			
	}
	
	function fetchered_listing($n=3){
		
		$sql = "SELECT * FROM `p_blog` WHERE status= 1 and hot = 1 LIMIT 0, $n";
		
		$query = $this->db->query($sql);
		
		return $query->result_array();
			
	}
	
	function photo($im, $t='banner'){
		if($im==0){
			return '';
		}else{		
			$noimg = FILE.'noimg.jpg';
			$a['img_thumb'] = $this->media->photo($im, 'thumb');
			$a['banner'] = $this->media->photo($im, 'banner');
			$a['img_main'] = $this->media->photo($im);
			if($noimg==$a['img_main']){ return ''; }
			$arr = $a;
			return $arr[$t];
		}
	}
	
	function word_lmit($str, $n=20){
		
		$con1 = $this->mylib->content_html_decode($str);
		$con = strip_tags($con1);
		$con_arr = explode(' ', $con);
	   
		if(count($con_arr) > $n){
			
		}else{ $n = count($con_arr) - 2; }
		$con_arr2 = array();
		for($i=0; $i < $n; $i++) $con_arr2[] = $con_arr[$i];
		$info = implode(' ', $con_arr2);
		return $info;
	}
	
	function listing(){
		
		$sql = "SELECT * FROM `p_blog` WHERE 1 ";
		$query = $this->db->query($sql);
   		$config['per_page'] = 20;
		$config['uri_segment'] = 3;
		$config['total_rows'] = $query->num_rows();
		$config['base_url'] = ADMIN_BASE_URL.'blogs/listing/';
		$offset = $this->uri->segment($config['uri_segment']);
		if(!$offset){ $offset = 0; }
		$this->mypagination->initialize($config); 
		
		$sql.= " LIMIT ".$offset.", ".$config['per_page'];
		$query = $this->db->query($sql);
		
		return $query->result_array();
			
	}
	
	function get_list($t='category'){
		$tbl = 'p_blog_category';
		if($t=='tags') $tbl = 'p_blog_tags';
		if($t=='arch') $tbl = 'p_blog_archieves';
		$sql = "SELECT * FROM $tbl WHERE  status = '1' ";
		$query = $this->db->query($sql);
		
		return $query->result_array();
	}
	
	function get_count($id, $t='category'){
		$fl = 'category_id';
		if($t=='arch') $fl = 'archieve';
		
		$sql = "SELECT * FROM `p_blog` WHERE status = '1' AND $fl = '$id'  ORDER BY `poston` DESC ";
		$query = $this->db->query($sql);
		
		return $query->num_rows();
	}
	
	
	function get_name($id){
		$v = '';
		if(isset($this->atr[$id])){
			$v = $this->atr[$id];
		}else{
			$sql = "SELECT * FROM `p_category` WHERE id = $id";
			$query = $this->db->query($sql);
			foreach($query->result() as $ro){
				$v = $ro->category;
				$this->atr[$id] = $v;
			}
		}
		return $v;
	}
	
	function get_category_byid($id){
		
		$id = ($id==0)?'':$id ;
		$row['id'] = $id;
		$row['urlkey'] = '';
		$row['name'] = '';
		$row['status'] = '1';
		$sql = "SELECT * FROM p_blog_category WHERE id = '$id'";
		$query = $this->db->query($sql);
        foreach($query->result_array() as $ro){
			$row = $ro;
			
		}
		
		return $row; 
	}
	
	function get_tag_byid($id){
		
		$id = ($id==0)?'':$id ;
		$row['id'] = $id;
		$row['urlkey'] = '';
		$row['name'] = '';
		$row['status'] = '1';
		$sql = "SELECT * FROM p_blog_tags WHERE id = '$id'";
		$query = $this->db->query($sql);
        foreach($query->result_array() as $ro){
			$row = $ro;
			
		}
		
		return $row; 
	}
	
	function get_archieves_byid($id){
		
		$id = ($id==0)?'':$id ;
		$row['id'] = $id;
		$row['urlkey'] = '';
		$row['name'] = '';
		$row['status'] = '1';
		$sql = "SELECT * FROM p_blog_archieves WHERE id = '$id'";
		$query = $this->db->query($sql);
        foreach($query->result_array() as $ro){
			$row = $ro;
			
		}
		
		return $row; 
	}
	
	function get_blog($id, $f='urlkey'){
		
		
		$row['id'] = '';
		$row['urlkey'] = '';
		$row['title'] = '';
		$row['article'] = '';
		$row['postby'] = '';
		$row['poston'] = date('Y-m-d');
		$row['category_id'] = '';
		$row['arch'] = $row['archieve'] = array();
		$row['tgs'] = $row['tags'] = array();
		$row['blog_imgs'] = array();
		$row['status'] = '1';
		$row['hot'] = '0';
		$sql = "SELECT * FROM p_blog WHERE $f = '$id'";
		$query = $this->db->query($sql);
        foreach($query->result_array() as $ro){
			$row = $ro;
			$row['blog_tags'] = $this->get_attr($ro['tag']);
			$ld = $ro['tag'] . '|0|';
			$ld = str_replace("||", ",", $ld);
			$ld = str_replace("|", "", $ld);
			$row['tgs'] = explode(',', $ld);
			
			$row['blog_imgs'] = $this->media->photoList($ro['id'], 'blog');
		}
		
		return $row; 
	}
	
	function save($value=array()){
		return $this->db->save('p_category' , $value);
	}
	
	function del_tag($id){
		$query = $this->db->query("DELETE p_blog_tags WHERE id = $id");
		return $query;
	}
	
	function delete($id){
		$query = $this->db->query("DELETE p_category WHERE id = $id");
		$query = $this->db->query("DELETE p_category WHERE pid = $id");
		return $query;
	}
	
	function get_attr($d, $f=''){
		$tbl = 'p_blog_tags';
		if($f=='arch') $tbl = 'p_blog_archieves';
		$sql = "SELECT * FROM $tbl WHERE  status = '1'  ";
		$ld = $d . '|0|';
		$ld = str_replace("||", ",", $ld);
		$ld = str_replace("|", "", $ld);
		
		$query = $this->db->query($sql);
		return $query->result_array();
	}
	
	function get_blogs($n=10, $fetchered=0){
		
		$fe = ($fetchered==1)? " AND `hot` = 1 ":'';
		$sql = "SELECT * FROM `p_blog` WHERE `status` = 1 $fe ORDER BY `poston` DESC ";
		$query = $this->db->query($sql);
   		$config['per_page'] = $n;
		$config['uri_segment'] = 3;
		$config['total_rows'] = $query->num_rows();
		
		/* Pagination HTML Configeration   */
		$pagin_config['num_links'] = 6;
		$pagin_config['full_tag_open'] = '<ul class="pagination pagination-lg">'; 
		$pagin_config['full_tag_close'] = '</ul>';
		$pagin_config['num_tag_open'] = '<li>'; 
		$pagin_config['num_tag_close'] = '</li>';
		$pagin_config['prev_tag_open'] = '<li>';
		$pagin_config['prev_tag_close'] = '</li>';
		$pagin_config['next_tag_open'] = '<li>';
		$pagin_config['next_tag_close'] = '</li>';
		$pagin_config['cur_tag_open'] = '<li class="active"><a href="#">';
		$pagin_config['cur_tag_close'] = '</a></li>';
		$pagin_config['last_tag_open'] = '<li>';
		$pagin_config['last_tag_close'] = '</li>';
		$pagin_config['first_tag_open'] = '<li>';
		$pagin_config['first_tag_close'] = '</li>';
		$pagin_config['first_link'] = 'Previous';
		$pagin_config['last_link'] = 'Next';
		// END Pagination HTML Configeration   
		
		$config['base_url'] = BASE_URL.'blog-list-';
		$offset = $this->uri->segment($config['uri_segment']);
		if(!$offset){ $offset = 0; }
		$this->mypagination->initialize($config); 
		
		$sql.= " LIMIT ".$offset.", ".$config['per_page'];
		$query = $this->db->query($sql);
		
		return $query->result_array();
		
	}
	
	function my_blogs($user_id, $n=10, $fetchered=0){
		
		$fe = ($fetchered==1)? " AND `hot` = 1 ":'';
		$fe.= " AND `user_id` = ".$user_id;
		
		$sql = "SELECT * FROM `p_blog` WHERE `status` = 1 $fe ORDER BY `poston` DESC ";
		$query = $this->db->query($sql);
   		$config['per_page'] = $n;
		$config['uri_segment'] = 3;
		$config['total_rows'] = $query->num_rows();
		
		/* Pagination HTML Configeration   */
		$pagin_config['num_links'] = 6;
		$pagin_config['full_tag_open'] = '<ul class="pagination pagination-lg">'; 
		$pagin_config['full_tag_close'] = '</ul>';
		$pagin_config['num_tag_open'] = '<li>'; 
		$pagin_config['num_tag_close'] = '</li>';
		$pagin_config['prev_tag_open'] = '<li>';
		$pagin_config['prev_tag_close'] = '</li>';
		$pagin_config['next_tag_open'] = '<li>';
		$pagin_config['next_tag_close'] = '</li>';
		$pagin_config['cur_tag_open'] = '<li class="active"><a href="#">';
		$pagin_config['cur_tag_close'] = '</a></li>';
		$pagin_config['last_tag_open'] = '<li>';
		$pagin_config['last_tag_close'] = '</li>';
		$pagin_config['first_tag_open'] = '<li>';
		$pagin_config['first_tag_close'] = '</li>';
		$pagin_config['first_link'] = 'Previous';
		$pagin_config['last_link'] = 'Next';
		// END Pagination HTML Configeration   
		
		$config['base_url'] = BASE_URL.'blog-list-';
		$offset = $this->uri->segment($config['uri_segment']);
		if(!$offset){ $offset = 0; }
		$this->mypagination->initialize($config); 
		
		$sql.= " LIMIT ".$offset.", ".$config['per_page'];
		$query = $this->db->query($sql);
		
		return $query->result_array();
		
	}
	
	function getby_blogs($n=10){
		
		$fe = "  ";
		$t1 = $this->uri->segment(1);
		$t2 = $this->uri->segment(2);
		
		if($t1=='blog-category'){
			$cat = $this->dtable->blog_category->get($t2, 'urlkey');
			$cat_id = $cat['id'];
			$fe = " AND category_id = '$cat_id' ";
		}
		
		if($t1=='blog-tag'){
			$cat = $this->dtable->blog_tags->get($t2, 'urlkey');
			$tag_id = $cat['id'];
			$fe = " AND tag LIKE '%|".$tag_id."|%' ";
		}
		
		$sql = "SELECT * FROM `p_blog` WHERE `status` = 1 $fe ORDER BY `poston` DESC ";
		$query = $this->db->query($sql);
   		$config['per_page'] = $n;
		$config['uri_segment'] = 3;
		$config['total_rows'] = $query->num_rows();
		
		/* Pagination HTML Configeration   */
		$pagin_config['num_links'] = 6;
		$pagin_config['full_tag_open'] = '<ul class="pagination pagination-lg">'; 
		$pagin_config['full_tag_close'] = '</ul>';
		$pagin_config['num_tag_open'] = '<li>'; 
		$pagin_config['num_tag_close'] = '</li>';
		$pagin_config['prev_tag_open'] = '<li>';
		$pagin_config['prev_tag_close'] = '</li>';
		$pagin_config['next_tag_open'] = '<li>';
		$pagin_config['next_tag_close'] = '</li>';
		$pagin_config['cur_tag_open'] = '<li class="active"><a href="#">';
		$pagin_config['cur_tag_close'] = '</a></li>';
		$pagin_config['last_tag_open'] = '<li>';
		$pagin_config['last_tag_close'] = '</li>';
		$pagin_config['first_tag_open'] = '<li>';
		$pagin_config['first_tag_close'] = '</li>';
		$pagin_config['first_link'] = 'Previous';
		$pagin_config['last_link'] = 'Next';
		// END Pagination HTML Configeration   
		
		$config['base_url'] = BASE_URL.'blog-list-';
		$offset = $this->uri->segment($config['uri_segment']);
		if(!$offset){ $offset = 0; }
		$this->mypagination->initialize($config); 
		
		$sql.= " LIMIT ".$offset.", ".$config['per_page'];
		$query = $this->db->query($sql);
		
		return $query->result_array();
		
	}
	
	
	function get_hot_blogs($n=6, $fetchered=1){
		
		$fe = ($fetchered==1)? " AND `hot` = 1 ":'';
		$sql = "SELECT * FROM `p_blog` WHERE `status` = 1 $fe  ORDER BY `poston` DESC  LIMIT 0, $n";
		$query = $this->db->query($sql);
   		
		return $query->result_array();
		
	}
	
	function decode($ver=''){
		$ver = $this->mylib->content_html_decode($ver);
	
		$html = explode('<body>', $ver);
		if(isset($html[1])) $ver = $html[1];
		$html = explode('</body>', $ver);
		$ver = $html[0];
		
		return $ver;
	}
	
	
}
?>