<?php
class Dtable extends CI_Model {
	
	function __construct(){
        // Call the Model constructor
        parent::__construct();
		$this->loadtables();
    }
	
	function loadtables(){
		$px = TBL_PREFIX.'_';
		$tables = $this->get_all_tables();
		if (!class_exists('Tbs')) {
			require_once(HEARD_PATH.'libraries/Tbs.php');
		}
		foreach($tables as $t){
			$tb = str_replace($px, '', $t);
			$this->$tb = new Tbs($t);
		}
	}

	public function get_all_tables(){
		$arr = $this->ds->sql('SHOW TABLES');
		$f = "Tables_in_" . DATABASE;
		$rs = array();
		foreach($arr as $r){
			$rs[] = $r[$f];
		}
		return $rs;
		
	}
	
	

	public function table_desc($table){
		$sql = " DESC $table ";
		$query = $this->db->query($sql);
		$fields = $query->list_fields(); 
		$query = $query->result_array();
		$rs = array();
		$ro = array();
		
		return $query;
	}
	
	public function table_create_sql($table){
		$sql = "SHOW CREATE TABLE $table ";
		$query = $this->db->query($sql);
		$fields = $query->list_fields(); 
		$query = $query->result_array();
		$rs = array();
		$ro = array();
		
		return $query[0]['Create Table'];
	}
	
	function table($table, $con=array(), $uri_segment=3){
		if($table==''){ 
			return '';
		}
		$px = TBL_PREFIX.'_';
		$tbl = $px.$table;
		$arr = array();
		if(isset($con['where'])){ $where = $con['where']; }
		else { $where = array(); }
		$arr['where'] = $where;
		if(isset($con['limit'])){ $arr['limit'] = $con['limit']; }
		$data = array();
		$data['listing'] = $listing = $this->$table->listing($arr, $uri_segment);
		if(isset($con['fld'])){ $arr['fld'] = $con['fld']; }
		else { 
			$arr['fld'] = $fld = array(); 
			$table = $tbl;
			$sql = " DESC $table ";
			$query = $this->db->query($sql);
			$fields = $query->list_fields(); 
			$indx = $fields[0];
			$fields = $query->result(); 
			foreach($fields as $row){
				$fld[$row->$indx] = ($row->$indx);
			}
			$arr['fld'] = $fld ;
		}
		$data['fld'] = $arr['fld'];
		if(isset($con['act'])){ $arr['act'] = $con['act']; }
		else { $arr['act'] = array(); }
		$data['act'] = $arr['act'];
		
		if(isset($con['add_new'])){ $data['add_new'] = $con['add_new']; }
		if(isset($con['back'])){ $data['back'] = $con['back']; }
		
		
		return $this->load->view('common/table', $data, true);
	}
}
?>