<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Member extends CI_Controller {
	
	function  __construct(){
        parent::__construct();
        
        // Load paypal library & product model
        $this->load->library('paypal_lib');
    }
	
	public function index()
	{
		$data['cms'] = $this->user->is_login("My Account");
		$data['cms'] = $this->cms->get_cms_by_urlkey('myaccount');
		$user = $this->user->login_info();
		$this->user->profile_chq();
		$data['two_side'] = true;
		$data['scroller'] = true;
		
		
		$data['body'] = $this->load->view('user/myaccount', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	public function signup2(){
		$data['cms'] = $this->user->is_login("signup");
		$data['cms'] = $this->cms->get_cms_by_urlkey('signup');
		$data['user'] = $edit = $this->user->login_info();
		$a_id = $edit['id'];
		if(isset($_POST['model']) && $_POST['model']=='Submit'){
			
			$this->form_validation->set_rules('ph', ' Phone No.', 'required');
			$this->form_validation->set_rules('address', ' Address', 'required');
			$this->form_validation->set_rules('country', ' Country', 'required');
			$this->form_validation->set_rules('state', ' State', 'required');
			$this->form_validation->set_rules('city', ' City', 'required');
			$this->form_validation->set_rules('zip', ' Zip Code', 'required');
			
			$value = $this->input->post();
			$value['id'] = $a_id;
			
			if ($this->form_validation->run()){
			
				if(isset($value['business'])) {
					$value['business_type'] = array_to_pipe($value['business']);
					unset($value['business']);
				}
				//$value['reg_date'] = date('Y-m-d');
				
				$value['email_varified'] = 1;
				$id = $this->ds->save('p_users' , $value);
				redirect('member/');
				exit();
			}else{
				$this->mylib->put_msg(validation_errors(), 0);
			}
		}
		
		
		$data['body'] = $this->load->view('user/signup2', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	public function signup3(){
		$data['cms'] = $this->user->is_login("signup");
		$data['cms'] = $this->cms->get_cms_by_urlkey('signup');
		$data['user'] = $edit = $this->user->login_info();
		$a_id = $edit['id'];
		$title = $edit['fname'].$edit['lname'];
		$data['urlkey'] = $this->user->profileid_create($title);
		if(isset($_POST['model']) && $_POST['model']=='Save'){
			$val = $this->input->post();
			$profile = $val['profile'];
			if($profile==""){
				$profileid = $this->user->profileid_create($title);				
			}else{
				$this->form_validation->set_rules('profile', ' Profile id', 'required|is_unique[p_users.profileid]');
				if ($this->form_validation->run()){
					$profileid = $this->user->profileid_create($title);				
				}else{
					$this->mylib->put_msg(validation_errors(), 0);
					redirect('member/');
					exit();
				}
			}
			$arr = array();
			$arr['id'] = $a_id;
			$arr['profileid'] = $profileid;
			$arr['reg_date'] = date('Y-m-d');
			$this->dtable->users->save($arr);
			redirect('member/');
			exit();
		}
		$data['body'] = $this->load->view('user/signup3', $data, true);
		$this->load->view('layout_inner2', $data);
		
	}
	
	public function edit()
	{
		$data['cms'] = $this->user->is_login("My Account");
		$data['cms'] = $this->cms->get_cms_by_urlkey('myaccount');
		//$data['cms'] = $this->user->is_login("Edit Details");
		$data['two_side'] = true;
		$data['scroller'] = true;
		$data['user'] = $edit = $this->user->login_info();
		$a_id = $edit['id'];
		if(isset($_POST['model']) && $_POST['model']=='edit'){
			
			$this->form_validation->set_rules('fname', ' First Name ', 'required');
			$this->form_validation->set_rules('lname', ' Last Name', 'required');
			
			$this->form_validation->set_rules('ph', ' Phone No.', 'required');
			$this->form_validation->set_rules('address', ' Address', 'required');
			$this->form_validation->set_rules('country', ' Country', 'required');
			$this->form_validation->set_rules('state', ' State', 'required');
			$this->form_validation->set_rules('city', ' City', 'required');
			$this->form_validation->set_rules('zip', ' Zip Code', 'required');
			
			$value = $this->input->post();
			$value['id'] = $a_id;
			
			if ($this->form_validation->run()){
				
				if(isset($value['business'])) {
					$value['business_type'] = array_to_pipe($value['business']);
					unset($value['business']);
				}
				//$value['reg_date'] = date('Y-m-d');
				
				$id = $this->ds->save('p_users' , $value);
				
				$msg = $this->load->view('email/edit_user', array('id'=>$a_id), true);
				$sub = "Mendocino Access Television - Member Record modified ";
				//$this->sendmail->send($edit['email'], $sub, $msg);
				
				$msg = $this->load->view('email/edit_user', array('id'=>$a_id), true);
				$sub = "MA Television - Edited info by ".$value['fname'];
				//$this->sendmail->toadmin($sub, $msg);
				
				$msg = "Record modified";
				$this->mylib->put_msg($msg, 1);
				redirect('member/');
				exit();
			}else{
				
				$this->mylib->put_msg(validation_errors(), 0);

			}
		}
		
		$data['body'] = $this->load->view('user/edit', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	function album(){
		$data['cms'] = $this->user->is_login("My Account");
		$data['cms'] = $this->cms->get_cms_by_urlkey('myaccount');
		//$data['cms'] = $this->user->is_login("Edit Details");
		$data['two_side'] = true;
		$data['scroller'] = true;
		$data['user'] = $edit = $this->user->login_info();
		$data['listing'] = $this->albumpic->photoListing($edit['id'], array());
		
		$data['body'] = $this->load->view('user/album', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	function add_photo(){
		$data['cms'] = $this->user->is_login("My Account");
		$data['cms'] = $this->cms->get_cms_by_urlkey('myaccount');
		$data['user'] = $edit = $this->user->login_info();
		if(isset($_FILES['img'])){
			
			$img_id = $this->albumpic->upload('img', $edit['id']);
			if($img_id!=''){
				$this->mylib->put_msg('Photo upload successfully', 1);
				redirect('member/show_photo/'.$img_id);
				exit();
			}else{
				$this->mylib->put_msg('Photo upload Fail !!', 0);
			}
			redirect('member/add_photo/');
				exit();
		}
		
		$data['body'] = $this->load->view('user/addphoto', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	function show_photo($id){
		$data['cms'] = $this->user->is_login("My Account");
		$data['cms'] = $this->cms->get_cms_by_urlkey('myaccount');
		$data['user'] = $edit = $this->user->login_info();
		if(isset($_POST['allow'])){
			$arr['id'] = $id;
			$arr['allow'] = $_POST['allow'];
			$arr['postdate'] = time();
			$img_id = $this->ds->save('p_album' , $arr);
			redirect('member/album/');
				exit();
		}
		$data['pic'] = $this->albumpic->photoSingle($id);
		
		$data['body'] = $this->load->view('user/showphoto', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	function mygroups(){
		$data['cms'] = $this->user->is_login("My Account");
		$data['cms'] = $this->cms->get_cms_by_urlkey('myaccount');
		//$data['cms'] = $this->user->is_login("Edit Details");
		$data['two_side'] = true;
		$data['scroller'] = true;
		$data['user'] = $edit = $this->user->login_info();
		$data['listing'] = $listing = $this->groups->groupListing($edit['id'], array());
		
		$data['body'] = $this->load->view('user/mygroups', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	function create_group(){
		$data['cms'] = $this->user->is_login("My Account");
		$data['cms'] = $this->cms->get_cms_by_urlkey('myaccount');
		$data['user'] = $edit = $this->user->login_info();
		$value['info'] = '';
		$value['title'] = '';
		if(isset($_POST['title'])){
			$value = $this->input->post();
			$this->form_validation->set_rules('title', ' Group Title', 'required');
			$this->form_validation->set_rules('info', ' Details about Group', 'required');
			if ($this->form_validation->run()){
				$this->groups->create_new($value, $edit);
				redirect('member/mygroups/');
				exit();
			}else{
				$this->mylib->put_msg(validation_errors(), 0);
			}
		}
		$data['val'] = $value;
		$data['body'] = $this->load->view('user/create_group', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	function blogs(){
		$data['cms'] = $this->user->is_login("My Account");
		$data['cms'] = $this->cms->get_cms_by_urlkey('myaccount');
		//$data['cms'] = $this->user->is_login("Edit Details");
		$data['two_side'] = true;
		$data['scroller'] = true;
		$data['user'] = $edit = $this->user->login_info();
		
		
		$data['body'] = $this->load->view('user/blogs', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	function sign_act(){
		$frm_url1 = BASE_URL.'member/signup';
		$frm_url2 = BASE_URL.'signup';
		$f = 1;
		/*if($_SERVER['HTTP_REFERER']!=$frm_url1){
			//$this->mylib->put_msg('Request form wrong url.');
			//redirect(BASE_URL.'member/signup', 'refresh');
			echo 'Request form wrong url.';
			echo $_SERVER['HTTP_REFERER'];
			$f = 0;
		}
		if($_SERVER['HTTP_REFERER']!=$frm_url2){
			//$this->mylib->put_msg('Request form wrong url.');
			//redirect(BASE_URL.'member/signup', 'refresh');
			echo 'Request form wrong url.';
			echo $_SERVER['HTTP_REFERER'];
			$f = 0;
		}*/
		if($_SERVER['HTTP_REFERER']==$frm_url1 || $_SERVER['HTTP_REFERER']==$frm_url2){
			$this->form_validation->set_rules('fname', ' First Name ', 'required');
			$this->form_validation->set_rules('lname', ' Last Name', 'required');
			$this->form_validation->set_rules('email', ' Email', 'required|valid_email|is_unique[p_users.email]');
			$value = $this->input->post();
			$value['pass'] = $this->mylib->make_password();
			if ($this->form_validation->run()){
				$value['reg_date'] = date('Y-m-d');
				$id = $this->ds->save('p_users' , $value);
				$this->sendmail->send($value['email'], 1, $value);
				echo 'success';
				
			}else{
				echo validation_errors();
			}
		}else{
			echo 'Request form wrong url.';
			echo $_SERVER['HTTP_REFERER'];
		}
	
	}
	
	public function signup()
	{
		$data['cms'] = $this->cms->get_cms_by_urlkey('signup');
		$data['ro'] = array('fname'=>'', 'lname'=>'', 'email'=>'', );
		
		if(isset($_POST['model']) && $_POST['model']=='signup'){
			
			$this->form_validation->set_rules('fname', ' First Name ', 'required');
			$this->form_validation->set_rules('lname', ' Last Name', 'required');
			$this->form_validation->set_rules('email', ' Email', 'required|valid_email|is_unique[p_users.email]');
			/*$this->form_validation->set_rules('ph', ' Phone No.', 'required');
			$this->form_validation->set_rules('address', ' Address', 'required');
			$this->form_validation->set_rules('country', ' Country', 'required');
			$this->form_validation->set_rules('state', ' State', 'required');
			$this->form_validation->set_rules('city', ' City', 'required');
			$this->form_validation->set_rules('zip', ' Zip Code', 'required');*/
			
			$value = $this->input->post();
			$value['pass'] = $this->mylib->make_password();
			
			if ($this->form_validation->run()){
				
				/*if(isset($value['business'])) {
					$value['business_type'] = array_to_pipe($value['business']);
					unset($value['business']);
				}*/
				$value['reg_date'] = date('Y-m-d');
				
				$id = $this->ds->save('p_users' , $value);
				
				$this->sendmail->send($value['email'], 1, $value);
				/*$msg = $this->load->view('email/reg', array('id'=>$id), true);
				$sub = "Mendocino Access Television - registation ";
				$this->sendmail->send($value['email'], $sub, $msg);
				
				$msg = $this->load->view('email/reg_admin', array('id'=>$id), true);
				$sub = "MA Television - New registation of ".$value['fname'];
				$this->sendmail->toadmin($sub, $msg);*/
				
				$msg = "<p>Your membership registration into Mendocino Access Television was successful! Kindly check your mailbox and confirm your registration. If you don't see the email within a few minutes, check the spam/junk folder. </p> <p>Please you will need to update your passward and profile. Aso choose a membership level In order to benefit from the opportunities our television offers </p>";
				$this->mylib->put_msg($msg, 1);
				redirect('member/login/');
				exit();
			}else{
				

				$this->mylib->put_msg(validation_errors(), 0);
				$data['ro'] = $value;
			}
		}
		$data['body'] = $this->load->view('user/signup', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	public function photo()
	{
		$data['cms'] = $this->user->is_login("My Account");
		$data['cms'] = $this->cms->get_cms_by_urlkey('myaccount');
		//$data['cms'] = $this->user->is_login("Edit Details");
		$data['two_side'] = true;
		$data['scroller'] = true;
		$data['user'] = $edit = $this->user->login_info();
		$a_id = $edit['id'];
		
		if(isset($_POST['model']) && $_POST['model']=='Upload'){
			
			$img = $this->media->upload('img', 'profile', $a_id);
			if($img==''){
				$this->mylib->put_msg('Your Photo file not uploaded...', 0);
				redirect('member/photo/');
				exit();
			}else{
				$arr['id'] = $a_id;
				$arr['photo'] = $img;
				$id = $this->ds->save('p_users' , $arr);
				if($edit['photo']!='' && $edit['photo'] > 0){
					$this->media->delete($edit['photo']);
				}
				redirect('member/');
				exit();
			}
		}
		
		$data['body'] = $this->load->view('user/photo', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	public function login()
	{
		$data['cms'] = $this->cms->get_cms_by_urlkey('login');
		$data['scroller'] = true;
		$data['two_side'] = true;
		
		if(isset($_POST['email']) && $_POST['email']!=''){
			$val = $_POST;
			$this->user->get_login($val);
		}
		
		$data['body'] = $this->load->view('user/login', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	public function logout()
	{
		$this->user->logout();
	}
	
	public function upgread(){
		$data['cms'] = $this->cms->get_cms_by_urlkey("membership");
		$data['scroller'] = true;
		$data['two_side'] = true;
		$data['user'] = $user = $this->user->login_info();
		
		$data['body'] = $this->load->view('user/planlist', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	public function changepassword()
	{
		$data['cms'] = $this->user->is_login("Change Password");
		$data['cms'] = $this->cms->get_cms_by_urlkey('signup');
		$data['two_side'] = true;
		$data['scroller'] = true;
		if(isset($_POST['pass1'])){ 
			$this->form_validation->set_rules('pass1', 'Old Password', 'required');
			$this->form_validation->set_rules('pass2', 'New Password', 'required');
			$this->form_validation->set_rules('pass3', 'For Confermation Same New Password is', 'required|matches[pass2]');
			if ($this->form_validation->run())
			{
				$value = $this->input->post();
				if(!$this->user->update_password($value)){
					$this->mylib->put_msg("Invalid old password", 0);
				}
			}
		}
		$data['body'] = $this->load->view('user/changepssword', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	public function forgotpassword(){
		$data['cms'] = $this->cms->get_cms_by_urlkey('forgotpassword');
		$data['scroller'] = true;
		$data['two_side'] = true;
		
		if(isset($_POST['email']) && $_POST['email']!=''){
			$this->form_validation->set_rules('email', ' Email', 'required|valid_email');
			if ($this->form_validation->run()){
				$email = $_POST['email'];
				$this->user->forgotpassword($email);
				redirect('member/login/');
				exit();
			}else{
				$this->mylib->put_msg(validation_errors(), 0);
			}
		}
		
		//$data['body'] = $this->load->view('user/login', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	function buy($id){
        
		$user = $this->user->login_info();
		
		// Set variables for paypal form
        $returnURL = base_url().'paypal/success';
        $cancelURL = base_url().'paypal/cancel';
        $notifyURL = base_url().'paypal/ipn';
        
        // Get product data from the database
		$product = $this->exchange->myplan($p);
		if($p!=$id){
	        $product = $this->user->planinfo($id);
		}	
        
        // Get current user ID from the session
        $userID = $user['id'];
        
        // Add fields to paypal form
        $this->paypal_lib->add_field('return', $returnURL);
        $this->paypal_lib->add_field('cancel_return', $cancelURL);
        $this->paypal_lib->add_field('notify_url', $notifyURL);
        $this->paypal_lib->add_field('item_name', $product['title']);
        $this->paypal_lib->add_field('custom', $userID);
        $this->paypal_lib->add_field('item_number',  $product['id']);
        $this->paypal_lib->add_field('amount',  $product['cost']);
        
        // Render paypal form
        $this->paypal_lib->paypal_auto_form();
    }
	
	public function exchange()
	{
		$data['cms'] = $this->user->is_login("Exchange service request");
		$data['two_side'] = true;
		$data['scroller'] = true;
		$data['user'] = $edit = $this->user->login_info();
		$a_id = $edit['id'];
		
		if(isset($_POST['model']) && $_POST['model']=='exchange'){
			
			$this->form_validation->set_rules('role', ' Select Plan ', 'required');
			$this->form_validation->set_rules('req_amt', ' Put amount which you can pay', 'required');
			$this->form_validation->set_rules('offer_desc', ' About Yourself ', 'required');
			
			
			$value = $this->input->post();
			$value['user_id'] = $a_id;
			$value['dated'] = date('Y-m-d');
			
			if ($this->form_validation->run()){
				
				$id = $this->ds->save('p_exchange' , $value);
				$this->exchange->request_email($id);
				
				$msg = "Your exchange request send to us.";
				$this->mylib->put_msg($msg, 1);
				redirect('member/');
				exit();
			}else{
				
				$this->mylib->put_msg(validation_errors(), 0);

			}
		}
		
		$data['body'] = $this->load->view('user/exchange', $data, true);
		$this->load->view('layout_inner', $data);
	}
	
	function profile(){
		$data['cms'] = $this->user->is_login("My Account");
		$data['cms'] = $this->cms->get_cms_by_urlkey('myaccount');
		$user = $this->user->login_info();
		$prof_id = $this->uri->segment(1);
		$prof_id = str_replace('profile_', '', $prof_id);
		$data['user'] = $member = $this->user->get($prof_id, 'profileid');
		//pr($member);
		$data['body'] = $this->load->view('user/myaccount', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	function friendrequest($prof=''){
		
		$u = $this->user->login_info();
		if($prof==''){
			redirect('member/');
			exit();
		}else{
			$f = $this->dtable->users->get($prof, 'profileid');
			$param = (isset($_GET['param']))?$_GET['param']:'';
			$arr = array();
			$arr['user_id'] = $u['id'];
			$arr['friend_id'] = $f['id'];
			$fid = $this->dtable->friend->save($arr);
			if($fid!='' && $fid > 0){
				$uinfo = array();
				$uinfo['fname'] = $u['fname'];
				$uinfo['lname'] = $u['lname'];
				$uinfo['userinfo'] = $this->load->view('email/userinfo', $u, true);
				
				$this->sendmail->send($f['email'], 2, $uinfo);
			}
			if($param==''){
				redirect('member/');
			}else{
				redirect($param);
			}
			exit();
		}
		$this->mylib->put_msg("System Issue.");
		redirect('member/');
		exit();
	}
	
	function acceptfriend($req_id=''){
		
		$u = $this->user->login_info();
		if($req_id==''){
			redirect('member/');
			exit();
		}else{
			$req = $this->dtable->friend->get($req_id);
			$param = (isset($_GET['param']))?$_GET['param']:'';
			if($u['id']!=$req['friend_id']){
				$this->mylib->put_msg("Invalid Access.");
				redirect('member/');
				exit();
			}else{
				$arr = array();
				$arr['user_id'] = $u['id'];
				$arr['friend_id'] = $req['user_id'];
				$arr['status'] = 1;
				$arr['acp_id'] = $req_id;
				$fid = $this->dtable->friend->save($arr);
				$arr = array();
				$arr['id'] = $req_id;
				$arr['acp_id'] = $fid;
				$arr['status'] = 1;
				$d = $this->dtable->friend->save($arr);
				$f = $this->dtable->user->get($req['user_id']); 
				$uinfo = array();
				$uinfo['fname'] = $u['fname'];
				$uinfo['lname'] = $u['lname'];
				$uinfo['userinfo'] = $this->load->view('email/userinfo', $u, true);
				
				$this->sendmail->send($f['email'], 4, $uinfo);
				
				if($param==''){
						redirect('member/');
					}else{
						redirect($param);
					}
					exit();
				
			}
			
			
			
		}
		redirect('member/');
		exit();
	}
	
	function rejectfriend($req_id=''){
		
		$u = $this->user->login_info();
		if($req_id==''){
			redirect('member/');
			exit();
		}else{
			$req = $this->dtable->friend->get($req_id);
			$param = (isset($_GET['param']))?$_GET['param']:'';
			if($u['id']!=$req['friend_id']){
				$this->mylib->put_msg("Invalid Access.");
				redirect('member/');
				exit();
			}else{
				$d = $this->dtable->friend->delete($req_id);
				$f = $this->user->get($req['user_id']);
				$uinfo = array();
				$uinfo['fname'] = $u['fname'];
				$uinfo['lname'] = $u['lname'];
				$uinfo['userinfo'] = $this->load->view('email/userinfo', $f, true);
				
				$this->sendmail->send($f['email'], 5, $uinfo);
				
				if($param==''){
						redirect('member/');
					}else{
						redirect($param);
					}
					exit();
				
			}
			
		}
		redirect('member/');
		exit();
	}
	
	function unfriend($prof){
		
		$u = $this->user->login_info();
		$param = (isset($_GET['param']))?$_GET['param']:'';
		$this->user->unfriend($prof);
		if($param==""){
			redirect('member/');
		}else{
			redirect($param);
		}
		exit();
		
	}
	
	public function friends()
	{
		$data['cms'] = $this->user->is_login("My Account");
		$data['cms'] = $this->cms->get_cms_by_urlkey('myaccount');
		$data['user'] = $user = $this->user->login_info();
		$data['listing'] = $this->user->myfriends(24);
		$data['body'] = $this->load->view('profile/myfriends', $data, true);
		$this->load->view('layout_inner2', $data);
	}
	
	public function listing()
	{
		$data['cms'] = $this->user->is_login("My Account");
		$data['cms'] = $this->cms->get_cms_by_urlkey('myaccount');
		$data['user'] = $user = $this->user->login_info();
		$data['listing'] = $this->user->profiles();
		$data['body'] = $this->load->view('profile/allmembers', $data, true);
		$this->load->view('layout_inner2', $data);
	}
}