<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
         <title><?php echo $cms['pagetitle'] ?></title>	
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta name="description" content="<?php echo $cms['metadesc'] ?>">
        <meta name="keywords" content="<?php echo $cms['metakeywords'] ?>">
		
		<meta property="og:title" content="<?php echo $cms['pagetitle'] ?>" />
		<meta property="og:type" content="website"/>
		<meta property="og:url" content="https://www.mendocinoaccess.org" />
		<meta property="og:image" content="<?php echo FRONT_THEME_PATH ?>studio.jpg" />
		<meta property="og:image:alt" content="" />
		<meta property="og:site_name" content="Mendocino Access Television" />
		<meta property="og:description" content="<?php echo $cms['metadesc'] ?>" />
		
        <link rel="shortcut icon" href="<?php echo FRONT_THEME_PATH ?>favicon.ico" type="image/x-icon">
		<link rel="icon" href="<?php echo FRONT_THEME_PATH ?>favicon.ico" type="image/x-icon">
		
        <link rel="stylesheet" type="text/css" href="<?php echo THEME_PATH ?>css/animate.css" />
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" integrity="sha384-B0vP5xmATw1+K9KRQjQERJvTumQW0nPEzvF6L/Z6nronJ3oUOFUFpCjEUQouq2+l" crossorigin="anonymous" />
        <link rel="stylesheet" type="text/css" href="<?php echo THEME_PATH ?>css/flatpickr.min.css" />
        <link rel="stylesheet" type="text/css" href="<?php echo THEME_PATH ?>css/fontello.css" />
        <link rel="stylesheet" type="text/css" href="<?php echo THEME_PATH ?>css/fontello-codes.css" />
        <link rel="stylesheet" type="text/css" href="<?php echo THEME_PATH ?>css/thumbs-embedded.css" />
        <link rel="stylesheet" type="text/css" href="<?php echo THEME_PATH ?>css/style.css" />
        <link rel="stylesheet" type="text/css" href="<?php echo THEME_PATH ?>css/responsive.css" />
        <link rel="stylesheet" type="text/css" href="<?php echo THEME_PATH ?>css/color.css" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    </head>

    <body>
        <div class="wrapper hp_1">
            <?php echo $this->load->view('common/header_sec', array(), true); ?>

            
            <!--side_menu end-->

            <section class="main-video-area">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="video-selected">
                                <div class="video-iframe">
                                    <?php echo $this->video->show_of_date($videos); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 video-thumbnails mt-2">
                            <ul class="nav nav-tabs" id="myTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">NEW</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">MOST WATCHED</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link" id="contact-tab" data-toggle="tab" href="#contact" role="tab" aria-controls="contact" aria-selected="false">POPULAR</a>
                                </li>
                            </ul>
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                                <?php foreach($videos as $v){ ?>    
                                    <div class="video-thumb">
                                        <div class="media">
                                            <img class="mr-3" src="<?php echo $v['poster'] ?>" />
                                            <div class="media-body">
                                                <h5 class="mt-0"><?php echo $v['title'] ?></h5>
                                                <p><?php echo $v['channel'] ?> :: <?php echo $v['program'] ?></p>
                                            </div>
                                        </div>
                                        
                                        <?php echo $v['video'] ?>
                                    </div>
									<?php } ?>
                                    

                                    
                                </div>
								<?php $mvideos = $this->video->show_mostviews(); ?>
                                <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                                    
									<?php foreach($mvideos as $v){ ?>    
                                    <div class="video-thumb">
                                        <div class="media">
                                            <img class="mr-3" src="<?php echo $v['poster'] ?>" />
                                            <div class="media-body">
                                                <h5 class="mt-0"><?php echo $v['title'] ?></h5>
                                                <p><?php echo $v['channel'] ?> :: <?php echo $v['program'] ?></p>
                                            </div>
                                        </div>
                                        
                                        <?php echo $v['video'] ?>
                                    </div>
									<?php } ?>

                                    
                                </div>
                                <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                                    <?php  
									$top_vids = $this->video->show_new();
									
									?>
									<?php foreach($top_vids as $v){ ?>    
                                    <div class="video-thumb">
                                        <div class="media">
                                            <img class="mr-3" src="<?php echo $v['poster'] ?>" />
                                            <div class="media-body">
                                                <h5 class="mt-0"><?php echo $v['title'] ?></h5>
                                                <p><?php echo $v['channel'] ?> :: <?php echo $v['program'] ?></p>
                                            </div>
                                        </div>
                                        
                                        <?php echo $v['video'] ?>
                                    </div>
									<?php } ?>

                                    

                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!--banner-section end-->

            <section class="services-sec">
                <div class="container">
                    <div class="services-row">
                        <div class="row">
                            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                                <div class="service-col">
                                    <img src="<?php echo THEME_PATH ?>images/icon-1.png" alt="" />
                                    <h3>Support MATV</h3>
                                    <p>Accept money from your fans through tips and grow Up.</p>
                                    <div class="link-goto">
                                        <a href="#">Go To&emsp;<i class="fa fa-long-arrow-right" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                                <!--service-col end-->
                            </div>
                            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                                <div class="service-col">
                                    <img src="<?php echo THEME_PATH ?>images/icon-2.png" alt="" />
                                    <h3>Mindfulness and Meditation</h3>
                                    <p>ASHINGNE solves familiar challenges victimizing millions of people worldwide.</p>
                                    <div class="link-goto">
                                        <a href="#">Go To&emsp;<i class="fa fa-long-arrow-right" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                                <!--service-col end-->
                            </div>
                            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                                <div class="service-col">
                                    <img src="<?php echo THEME_PATH ?>images/icon-3.png" alt="" />
                                    <h3>Transfer From YouTube</h3>
                                    <p>Upload your videos from YouTube with an easy link copy/paste.</p>
                                    <div class="link-goto">
                                        <a href="#">Go To&emsp;<i class="fa fa-long-arrow-right" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                                <!--service-col end-->
                            </div>
                            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                                <div class="service-col">
                                    <img src="<?php echo THEME_PATH ?>images/icon-4.png" alt="" />
                                    <h3>Mendocino Online Shopping</h3>
                                    <p>Get creative and productive, we will sell and you get paid.</p>
                                    <div class="link-goto">
                                        <a href="#">Go To&emsp;<i class="fa fa-long-arrow-right" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                                <!--service-col end-->
                            </div>
                        </div>
                    </div>
                    <!--services-row end-->
                </div>
            </section>
            <!--services-sec end-->

            <section class="vds-main-odd">
                <div class="vidz-row">
                    <div class="container">
                        <div class="vidz_sec">
                            <h3>Featured Shows<span><a href="#"><i class="fa fa-th" aria-hidden="true"></i>&emsp;View All</a></span></h3>
                            <div class="vidz_list">
                                <div class="row">
                                    <?php  
									$fvids = $this->video->show_featured();
									foreach($top_vids as $v){
									?>
									
									<div class="col-lg-3 col-md-6 col-sm-6 col-6 full_wdth">
                                        <div class="videoo">
                                            <div class="vid_thumbainl">
                                                <a href="<?php echo $v['details_url'] ?>" title="">
                                                    <img src="<?php echo $v['poster'] ?>" alt="" />
                                                    <!--<span class="vid-time">10:21</span>-->
                                                    <span class="watch_later">
                                                        <i class="icon-watch_later_fill"></i>
                                                    </span>
                                                </a>
                                            </div>
                                            <!--vid_thumbnail end-->
                                            <div class="video_info">
                                                <h3><a href="<?php echo $v['details_url'] ?>" title=""><?php echo $v['title'] ?></a></h3>
                                                <h4>
                                                    <a href="#" title=""><?php echo $v['channel'] ?></a> :: <a href="#" title=""><?php echo $v['program'] ?></a> <!--<span class="verify_ic"><i class="icon-tick"></i></span>-->
                                                </h4>
                                                <span><?php echo $v['views'] ?> views .<!--<small class="posted_dt">1 week ago</small>--></span>
                                            </div>
                                        </div>
                                        <!--videoo end-->
                                    </div>
									<?php } ?>
									
                                </div>
                            </div>
                            <!--vidz_list end-->
                        </div>
                        <!--vidz_videos end-->
                    </div>
                </div>
            </section>
            <!--vidz-row end-->
            <section class="vds-main-even">
                <div class="vidz-row">
                    <div class="container">
                        <div class="vidz_sec">
                            <h3>Social Forum <span><a href="#"><i class="fa fa-th" aria-hidden="true"></i>&emsp;View All</a></span></h3>
                            <div class="vidz_list">
                                <div class="row">
                                    <div class="col-lg-3 col-md-6 col-sm-6 col-6 full_wdth">
                                        <div class="videoo">
                                            <div class="vcp_inf">
                                                <div class="vc_hd">
                                                    <img src="<?php echo THEME_PATH ?>images/resources/th1.jpg" alt="" />
                                                </div>
                                                <div class="vc_info">
                                                    <h4><a href="Single_Channel_Home.html" title="">TrashPanda</a></h4>
                                                </div>
                                                <span class="vc-count">3</span>
                                            </div>
                                            <div class="vid_thumbainl">
                                                <a href="single_video_page.html" title="">
                                                    <img src="<?php echo THEME_PATH ?>images/resources/vide9.jpg" alt="" />
                                                    <span class="vid-time">4:01</span>
                                                    <span class="watch_later">
                                                        <i class="icon-watch_later_fill"></i>
                                                    </span>
                                                </a>
                                            </div>
                                            <!--vid_thumbnail end-->
                                            <div class="video_info">
                                                <h3><a href="single_video_page.html" title="">Trailer Park Boys Season 12 - Official Trailer</a></h3>
                                                <h4><a href="Single_Channel_Home.html" title="">ScereBro</a></h4>
                                                <span>45K views .<small class="posted_dt">3 days ago</small></span>
                                            </div>
                                        </div>
                                        <!--videoo end-->
                                    </div>
                                    <div class="col-lg-3 col-md-6 col-sm-6 col-6 full_wdth">
                                        <div class="videoo">
                                            <div class="vcp_inf">
                                                <div class="vc_hd">
                                                    <img src="<?php echo THEME_PATH ?>images/resources/th2.jpg" alt="" />
                                                </div>
                                                <div class="vc_info">
                                                    <h4><a href="Single_Channel_Home.html" title="">The 80’s Guy</a></h4>
                                                </div>
                                                <span class="vc-count">6</span>
                                            </div>
                                            <div class="vid_thumbainl">
                                                <a href="single_video_page.html" title="">
                                                    <img src="<?php echo THEME_PATH ?>images/resources/vide10.jpg" alt="" />
                                                    <span class="vid-time">6:20</span>
                                                    <span class="watch_later">
                                                        <i class="icon-watch_later_fill"></i>
                                                    </span>
                                                </a>
                                            </div>
                                            <!--vid_thumbnail end-->
                                            <div class="video_info">
                                                <h3><a href="single_video_page.html" title="">A day in the life of a Google software engineer</a></h3>
                                                <h4><a href="Single_Channel_Home.html" title="">MathChief</a></h4>
                                                <span>86K views .<small class="posted_dt">6 days ago</small></span>
                                            </div>
                                        </div>
                                        <!--videoo end-->
                                    </div>
                                    <div class="col-lg-3 col-md-6 col-sm-6 col-6 full_wdth">
                                        <div class="videoo">
                                            <div class="vcp_inf">
                                                <div class="vc_hd">
                                                    <img src="<?php echo THEME_PATH ?>images/resources/th3.jpg" alt="" />
                                                </div>
                                                <div class="vc_info">
                                                    <h4><a href="Single_Channel_Home.html" title="">Seeker</a></h4>
                                                </div>
                                                <span class="vc-count">2</span>
                                            </div>
                                            <div class="vid_thumbainl">
                                                <a href="single_video_page.html" title="">
                                                    <img src="<?php echo THEME_PATH ?>images/resources/vide11.jpg" alt="" />
                                                    <span class="vid-time">8:16</span>
                                                    <span class="watch_later">
                                                        <i class="icon-watch_later_fill"></i>
                                                    </span>
                                                </a>
                                            </div>
                                            <!--vid_thumbnail end-->
                                            <div class="video_info">
                                                <h3><a href="single_video_page.html" title="">Avengers: Infinity War - Gym Workout </a></h3>
                                                <h4>
                                                    <a href="Single_Channel_Home.html" title="">RealLifeLore</a> <span class="verify_ic"><i class="icon-tick"></i></span>
                                                </h4>
                                                <span>144K views .<small class="posted_dt">6 days ago</small></span>
                                            </div>
                                        </div>
                                        <!--videoo end-->
                                    </div>
                                    <div class="col-lg-3 col-md-6 col-sm-6 col-6 full_wdth">
                                        <div class="videoo">
                                            <div class="vcp_inf">
                                                <div class="vc_hd">
                                                    <img src="<?php echo THEME_PATH ?>images/resources/th4.jpg" alt="" />
                                                </div>
                                                <div class="vc_info">
                                                    <h4><a href="Single_Channel_Home.html" title="">Rivvrs</a></h4>
                                                </div>
                                                <span class="vc-count">7</span>
                                            </div>
                                            <div class="vid_thumbainl">
                                                <a href="single_video_page.html" title="">
                                                    <img src="<?php echo THEME_PATH ?>images/resources/vide12.jpg" alt="" />
                                                    <span class="vid-time">29:32</span>
                                                    <span class="watch_later">
                                                        <i class="icon-watch_later_fill"></i>
                                                    </span>
                                                </a>
                                            </div>
                                            <!--vid_thumbnail end-->
                                            <div class="video_info">
                                                <h3><a href="single_video_page.html" title="">How the Universe Works - The Milky Way Galaxy - Space</a></h3>
                                                <h4><a href="Single_Channel_Home.html" title="">Loskes</a></h4>
                                                <span>408K views .<small class="posted_dt">19 hours ago</small></span>
                                            </div>
                                        </div>
                                        <!--videoo end-->
                                    </div>
                                </div>
                            </div>
                            <!--vidz_list end-->
                        </div>
                        <!--vidz_videos end-->
                    </div>
                </div>
            </section>
            <!--vidz-row end-->
            <section class="vds-main-odd">
                <div class="vidz-row">
                    <div class="container">
                        <div class="vidz_sec">
                            <h3>Latest Show<span><a href="#"><i class="fa fa-th" aria-hidden="true"></i>&emsp;View All</a></span></h3>
                            <div class="vidz_list">
                                <div class="row">
                                    <?php  
									$v = $this->video->show_of_date($new_vids, 8);
									foreach($new_vids as $v){
									?>
									
									<div class="col-lg-3 col-md-6 col-sm-6 col-6 full_wdth">
                                        <div class="videoo">
                                            <div class="vid_thumbainl">
                                                <a href="<?php echo $v['details_url'] ?>" title="">
                                                    <img src="<?php echo $v['poster'] ?>" alt="" />
                                                    <!--<span class="vid-time">10:21</span>-->
                                                    <span class="watch_later">
                                                        <i class="icon-watch_later_fill"></i>
                                                    </span>
                                                </a>
                                            </div>
                                            <!--vid_thumbnail end-->
                                            <div class="video_info">
                                                <h3><a href="<?php echo $v['details_url'] ?>" title=""><?php echo $v['title'] ?></a></h3>
                                                <h4>
                                                    <a href="#" title=""><?php echo $v['channel'] ?></a> :: <a href="#" title=""><?php echo $v['program'] ?></a> <!--<span class="verify_ic"><i class="icon-tick"></i></span>-->
                                                </h4>
                                                <span><?php echo $v['views'] ?> views .<!--<small class="posted_dt">1 week ago</small>--></span>
                                            </div>
                                        </div>
                                        <!--videoo end-->
                                    </div>
									<?php } ?>
									
                                </div>
                            </div>
                            <!--vidz_list end-->
                        </div>
                        <!--vidz_videos end-->
                    </div>
                </div>
            </section>
            <!--vidz-row end-->
            <section class="vds-main-even">
                <div class="vidz-row">
                    <div class="container">
                        <div class="vidz_sec">
                            <h3>Popular Shows<span><a href="#"><i class="fa fa-th" aria-hidden="true"></i>&emsp;View All</a></span></h3>
                            <div class="vidz_list">
                                <div class="row">
                                    <?php  
									$fvids = $this->video->show_featured();
									foreach($top_vids as $v){
									?>
									
									<div class="col-lg-3 col-md-6 col-sm-6 col-6 full_wdth">
                                        <div class="videoo">
                                            <div class="vid_thumbainl">
                                                <a href="<?php echo $v['details_url'] ?>" title="">
                                                    <img src="<?php echo $v['poster'] ?>" alt="" />
                                                    <!--<span class="vid-time">10:21</span>-->
                                                    <span class="watch_later">
                                                        <i class="icon-watch_later_fill"></i>
                                                    </span>
                                                </a>
                                            </div>
                                            <!--vid_thumbnail end-->
                                            <div class="video_info">
                                                <h3><a href="<?php echo $v['details_url'] ?>" title=""><?php echo $v['title'] ?></a></h3>
                                                <h4>
                                                    <a href="#" title=""><?php echo $v['channel'] ?></a> :: <a href="#" title=""><?php echo $v['program'] ?></a> <!--<span class="verify_ic"><i class="icon-tick"></i></span>-->
                                                </h4>
                                                <span><?php echo $v['views'] ?> views .<!--<small class="posted_dt">1 week ago</small>--></span>
                                            </div>
                                        </div>
                                        <!--videoo end-->
                                    </div>
									<?php } ?>
									
                                </div>
								
                            </div>
                            <!--vidz_list end-->
                        </div>
                        <!--vidz_videos end-->
                    </div>
                </div>
            </section>
            <!--vidz-row end-->
            <section class="vds-main-odd">
                <div class="vidz-row pop_channels">
                    <div class="container">
                        <div class="vidz_sec">
                            <h3>Popular Channels<span><a href="#"><i class="fa fa-th" aria-hidden="true"></i>&emsp;View All</a></span></h3>
                            <div class="vidz_list">
                                <div class="row">
                                    <?php 
									$rows = $this->category->top_videos();    //upcomming();
									foreach($rows as $ro){ 
									
									?>
									
									<div class="col-lg-2 col-md-4 col-sm-4 col-6 full_wdth">
                                        <div class="videoo">
                                            <div class="vid_thumbainl">
                                               <a href="<?php echo BASE_URL.'channel/'.$ro['urlkey'] ?>" title="">
                                                    <img src="<?php echo $this->media->img($ro['img'], 'thumb') ?>" alt="" />
                                                </a>
                                            </div>
                                            <!--vid_thumbnail end-->
                                            <div class="video_info">
                                                <h3><a href="<?php echo BASE_URL.'channel/'.$ro['urlkey'] ?>" title=""><?php echo substr($ro['category'], 0,50); ?></a></h3>
                                                <span>230K Followers</span>
                                            </div>
                                        </div>
                                        <!--videoo end-->
                                    </div>
									<?php } ?>
									
                                   
                                </div>
                            </div>
                            <!--vidz_list end-->
                        </div>
                        <!--vidz_videos end-->
                    </div>
                </div>
                <!--vidz-row end-->
            </section>
            <!--vds-main end-->

            <?php echo $this->load->view('common/footer_sec', array(), true); ?>	
        </div>
        <!--wrapper end-->

        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
        <script src="<?php echo THEME_PATH ?>script.js"></script>

        <script src="<?php echo THEME_PATH ?>js/script-main.js"></script>
        <script src="<?php echo THEME_PATH ?>js/jquery.min.js"></script>
        <script src="<?php echo THEME_PATH ?>js/popper.js"></script>
        <script src="<?php echo THEME_PATH ?>js/bootstrap.min.js"></script>
        <script src="<?php echo THEME_PATH ?>js/flatpickr.js"></script>
        <script src="<?php echo THEME_PATH ?>js/script.js"></script>
    </body>
</html>